<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:inr="inr">
    <!-- Nasledujici Java Script funkcejsou funkce pouzite pro formatovani  -->
    <!-- cisel InRoads XML dat. Muzete je pouzit tak, jak jsou, nebo je     -->
    <!-- prepsat vlastnimi funkcemi pro formatovani. 						-->
    <!-- Tyto funkce nejsou nutne pro vytvareni vypisy   					-->
    <msxsl:script implements-prefix="inr" language="JScript">
        <![CDATA[
            // Desetinny oddelovac
            var decSep = ".";
            function SetDecSep( dS )
            {
                decSep = dS;
                return 1;
            }

            // Nastavuje, zda zahrnout priponu nebo ne
            var useAngSuffix = false;
            function UseAngSuffix( bAngSuffix )
            {
                useAngSuffix = bAngSuffix;
                return 1;
            }

            // Tato funkce formatuje pocet desetinnych mist.
            // prida nuly, pokud je to potreba.
            // num - cislo z xml
            // prec - pocet desetinnych mist za desetinnym oddelovacem
            function formatNumber(num, prec)
            {
                // kontrola, zda je spravne cislo
                if (!isNaN(num))
                {
                    if (num < 0)
                    {
                        //bere abrolutni hodnotu cisla
                        var absolutenum = Math.abs(num); 
                        var str = "" + Math.round(absolutenum * Math.pow(10, prec));
                        var absolutenum = Math.abs(num);
                        while (str.length <= prec)
                        {
                            str = "0" + str;
                        }
                        var decpoint = str.length - prec;
                        // prepise zaporne znaminko pokus je cislo zaporne
                        if (prec != 0)
                        {
                            return "-" + str.substring(0, decpoint) + decSep + str.substring(decpoint, str.length);
                        }
                        else
                        {
                            return "-" + str;
                        }
                    }
                    else
                    {
                        var str = "" + Math.round (num * Math.pow(10,prec));
                        while (str.length <= prec)
                        {
                            str = "0" + str;
                        }
                        var decpoint = str.length - prec;
                        if (prec != 0)
                        {
                            return str.substring(0, decpoint) + decSep + str.substring(decpoint, str.length);
                        }
                        else
                        {
                            return str;
                        }
                    }
                }
                return num;
            }
            
            // Tato funkce nastavuje format uhlove informace
            // n - hodnota z xml
            // format - (1 - "ddd^mm'ss.s", 2 - "ddd.ddd")
            // formatMethod - (1 - stupne, 2 - grady, 3 - radiany, 4 - mile)
            // precision - pocet cisel za desetinnou teckou
            function angularFormat(n, format, precision, formatMethod)
            {
                // kontrola, zda jde o platne cislo
                if (!isNaN(n))
                {
                    // prevadi z radianu na stupne a formatuje hodnotu
                    if (formatMethod == 1)
                    {
                        var decdeg = (n * 180) / Math.PI;
                        // format 1 - prevadi cislo na 
                        // "ddd^mm'ss.s"
                        if (format == 1)
                        {
                            // bere pouze cele cislo (ddd)
                            var deg = Math.floor(Math.abs(decdeg));
                            
                            // nasobi desetinnou cast krat 60 pro obdrzeni minut.
                            var decmin = (Math.abs(decdeg) - deg) * 60;
                            
                            // bere pouze celou cast cisla (mm')
                            var min = Math.floor(decmin);
                            
                            // nasobi desetinnou cast krat 60 pro obdrzeni sekund.
                            var decsec = (decmin - min) * 60;
                            
                            // vola funkci, ktera dava spravne cislo presnosti
                            var str = formatNumber(decsec, precision);
                            
                            if (  str.substring(0,2) == "60" )
                            {
                                decsec = 0;
                                str = formatNumber(decsec, precision);
                                min = min+1;
                                if ( min == 60 )
                                {
                                    min = 0;
                                    deg = deg + 1;
                                }
                            }
                                
                            if ( min < 10 )
                            {
                                min = "0" + min;
                            }
                            var sec = str;
                            if ( sec < 10 )
                            {
                                sec = "0" + sec;
                            }
                            
                            var msg;
                            if( decdeg >= 0 || decdeg <= -1 )
                            {
                                if( decdeg < 0 )
                                    msg =  "-" + deg + unescape("%b0") + min + "'" + sec + '"';
                                else
                                    msg =  deg + unescape("%b0") + min + "'" + sec + '"';
                            }
                            else
                                msg =  "-0" + unescape("%b0") + min + "'" + sec + '"';
                                
                            return msg;
                        }
                        // format 2 - "ddd.ddd"
                        if (format == 2)
                        {
                            // vola funkci, ktera dava spravne cislo presnosti
                            var str = formatNumber(decdeg, precision);
                            if (useAngSuffix == true)
                            {
                                str = str + unescape("%b0");
                            }
                            return str;
                        }
                    }
                    //prevadi radiany na grady
                    if (formatMethod == 2)
                    {
                        var radtograd = (n * 200) / Math.PI;
                        var grad = formatNumber(radtograd, precision);
                        if (useAngSuffix == true)
                        {
                            grad = grad + "g";
                        }
                        return grad;
                    }
                    // cislo v radianech je nutno formatovat
                    if (formatMethod == 3)
                    {
                        // vola funkci, ktera dava spravne cislo presnosti
                        var radian = formatNumber(n, precision);
                        if (useAngSuffix == true)
                        {
                            radian = radian + "r";
                        }
                        return radian;
                    }
                    //prevadi radiany na mile
                    if (formatMethod == 4 )
                    {
                         var radtomils = n * (6400.0 / (2.0 * Math.PI));
                         var mils = formatNumber( radtomils, precision );
                         return mils;
                    }
                }
                return "";
             }
        ]]>
    </msxsl:script>

    <xsl:variable name="CONVERT_TO_CY" select="'1'"/>
    <xsl:param name="xslConvertToCY" select="$CONVERT_TO_CY"/>
</xsl:stylesheet>
